﻿angular.module("umbraco").controller("MXMS.ObjectSelector", function ($scope, $http) {
    var url;
    var apiPath;

    if ($scope.model.config.apiPath == null || $scope.model.config.apiPath == '') {
        apiPath = 'api/entitystore/keyvalue/';
    }
    else {
        apiPath = $scope.model.config.apiPath;
    }

    if ($scope.model.config.mxmsurl == null || $scope.model.config.mxmsurl == '') {
        url = "/mxms/" + apiPath;
    }
    else {
        url = $scope.model.config.mxmsurl + apiPath;
    }
    if ($scope.model.config.path != null && $scope.model.config.path != '') {
        url = url + $scope.model.config.path.toLowerCase().replace('.', '/');
    }

    if ($scope.model.config.query != null && $scope.model.config.query != '') {
        url = url + '?where=' + encodeURIComponent($scope.model.config.query);
    }
    if ($scope.model.config.orderby != null && $scope.model.config.orderby != '') {
        if (url.indexOf('?') > -1) {
            url = url + '&orderby=' + encodeURIComponent($scope.model.config.orderby);
        }
        else {
            url = url + '?orderby=' + encodeURIComponent($scope.model.config.orderby);
        }
    }
    var container = $('.mxms-data-selector:not(\'.initialized\')');
    $scope._selector = $('<select></select>');
    container.append($scope._selector);
    $scope._selector.append('<option value="">' + $scope.model.config.emptylabel + '</option>');
    container.addClass('initialized');
    $scope._selector.change(function () {
        $scope.model.value = $scope._selector.val();
    });

    var headers = {};
    headers.Accept = 'application/json';
    if ($scope.model.config.apikey != null && $scope.model.config.apikey != '') {
        headers.Authorization = 'apikey ' + $scope.model.config.apikey;
    }

    $http.get(url, {
        headers: headers
    }).success(function (data, status, headers, config) {
        for(var i in data) {
            var item = data[i];
            $scope._selector.append('<option value="' + item.id + '">' + item.label + '</option>');
        }
        $scope._selector.val($scope.model.value);
    });
});