﻿angular.module("umbraco").controller("MXMS.MultiSelector", function ($scope, $http) {
    var requestContent = function (id, el) {
        var itemUrl;
        if ($scope.model.config.mxmsurl == null || $scope.model.config.mxmsurl == '') {
            itemUrl = "/mxms/api/entitystore/keyvalue/" + id;
        }
        else {
            itemUrl = $scope.model.config.mxmsurl + "api/entitystore/keyvalue/" + id;
        }

        $http.get(itemUrl, {
            headers: headers
        }).success(function (data, status, headers, config) {
            itemsContainer.sortable('refresh');
            el.attr('data-originaltext', data.label);
            var $span = el.find('span');
            $span.html(data.label);
            }).error(function () {
                el.remove();
                var index = values.indexOf(id);
                if (index > -1) {
                    values.splice(index, 1);
                    $scope.model.value = JSON.stringify(values);
                }
            });
    }

    var url;
    if ($scope.model.config.mxmsurl == null || $scope.model.config.mxmsurl == '') {
        url = "/mxms/api/entitystore/keyvalue/" + $scope.model.config.path.toLowerCase().replace('.', '/');
    }
    else {
        url = $scope.model.config.mxmsurl + "api/entitystore/keyvalue/" + $scope.model.config.path.toLowerCase().replace('.', '/');
    }
    if ($scope.model.config.query != null && $scope.model.config.query != '') {
        url = url + '?where=' + encodeURIComponent($scope.model.config.query);
    }
    if ($scope.model.config.orderby != null && $scope.model.config.orderby != '') {
        if (url.indexOf('?') > -1) {
            url = url + '&orderby=' + encodeURIComponent($scope.model.config.orderby);
        }
        else {
            url = url + '?orderby=' + encodeURIComponent($scope.model.config.orderby);
        }
    }

    var headers = {};
    headers.Accept = 'application/json';
    if ($scope.model.config.apikey != null && $scope.model.config.apikey != '') {
        headers.Authorization = 'apikey ' + $scope.model.config.apikey;
    }
    var values = $scope.model.value;
    if (values == null || values == '') {
        values = [];
        $scope.model.value = values;
    }
    var container = $('.mxms-multi-data-selector');
    var itemsContainer = $('<ul class="mxms-multi-data-selector-added-items"></ul>');
    var emptyMessage = $('<li class="mxms-multi-data-selector-added-items-empty-message">Geen items beschikbaar</li>');
    //itemsContainer.append(emptyMessage);

    for (var i in values) {
        var id = values[i];
        emptyMessage.hide();
        var $element = $('<li id="' + values[i] + '" data-originaltext=""><i class="handle"></i><span></span><button>delete</button></li>');
        itemsContainer.append($element);
        requestContent(id, $element);
    }
    var selectorContainer = $('<div class="mxms-multi-data-selector-add-selector">');
    var selectorLabel = $('<span>Voeg een item toe</span>');
    var selector = $('<select></select>');
    selectorContainer.append(selectorLabel);
    selectorContainer.append(selector);
    selectorContainer.hide();
    container.append(itemsContainer);
    container.append(selectorContainer);
    itemsContainer.sortable({
        handle: 'i.handle',
        onDrop: function ($item, cont, _super) {
            var items = container.find('li');
            values = [];
            for (var i in items) {
                var item = items[i];
                if (item.id != null && item.id != '') {
                    values.push(item.id);
                }
            }
            $scope.model.value = JSON.stringify(values);
            _super($item, cont);
        }
    });
    selector.append('<option selected="selected" value="">' + $scope.model.config.emptylabel + '</option>');
    $(selector).change(function () {
        var selectedItem = selector.children("option:selected");
        itemsContainer.append('<li id="' + selector.val() + '" data-originaltext="' + selectedItem.text() + '"><i class="handle"></i><span>' + selectedItem.text() + '</span><button>delete</button></li>');
        itemsContainer.sortable('refresh');
        emptyMessage.hide();
        values.push(selector.val());
        $scope.model.value = JSON.stringify(values);
        selectedItem.remove();
        if (selector.children().length == 1) {
            selectorContainer.hide();
        }
    });

    $http.get(url, {
        headers: headers
    }).success(function (data, status, headers, config) {
        for (var i in data) {
            var item = data[i];
            if (values.indexOf(item.id) == -1) {
                selector.append('<option value="' + item.id + '">' + item.label + '</option>');
            }
            if (selector.children().length == 1) {
                selectorContainer.hide();
            }
            else {
                selectorContainer.show();
            }
        }
    });

    itemsContainer.click(function (event) {
        if (event.target.tagName == 'BUTTON') {
            event.preventDefault();
            event.stopPropagation();
            var index = values.indexOf(event.target.parentNode.id);
            if (index > -1) {
                values.splice(index, 1);
                selector.append('<option value="' + event.target.parentNode.id + '">' + $(event.target.parentNode).data('originaltext') + '</option>');
                selectorContainer.show();
                event.target.parentNode.remove();
                if (itemsContainer.children().length == 1) {
                    emptyMessage.show();
                }
            }
        }
    });
});