﻿angular.module("umbraco").controller("MXMS.MultiTreeSelector", function ($scope, $http) {
    var url;
    var compact = true;
    $scope.model.hideLabel = !compact;
    if ($scope.model.config.mxmsurl == null || $scope.model.config.mxmsurl == '') {
        url = "/mxms/api/entitystore/hierarchy/" + $scope.model.config.path.toLowerCase().replace('.', '/');
    }
    else {
        url = $scope.model.config.mxmsurl + "api/entitystore/hierarchy/" + $scope.model.config.path.toLowerCase().replace('.', '/');
    }

    var headers = {};
    headers.Accept = 'application/json';
    if ($scope.model.config.apikey != null && $scope.model.config.apikey != '') {
        headers.Authorization = 'apikey ' + $scope.model.config.apikey;
    }


    $http.get(url, {
        headers: headers
    }).success(function (data, status, headers, config) {
        var trees = [];
        var tree = [],
        mappedArr = {},
        arrElem,
        mappedElem;
        for (var i = 0, len = data.length; i < len; i++) {
            arrElem = data[i];
            mappedArr[arrElem.id] = arrElem;
            mappedArr[arrElem.id]['children'] = [];
        }
        for (var id in mappedArr) {
            if (mappedArr.hasOwnProperty(id)) {
                mappedElem = mappedArr[id];
                if (mappedElem.parentID) {
                    mappedArr[mappedElem['parentID']]['children'].push(mappedElem);
                }
                else {
                    tree.push(mappedElem);
                }
            }
        }
        
        if (compact) {
            var fancyTree = createTree($scope, trees, tree);
            trees.push(fancyTree);
            var selectedNodes = fancyTree.getSelectedNodes();
            for (var i in selectedNodes) {
                var selectedNode = selectedNodes[i];
                expandTreeNode(selectedNode);
            }
        }
        else {
            for (var i in tree) {
                var rootTreeItem = tree[i];
                var fancyTree = createTree($scope, trees, rootTreeItem.children, rootTreeItem.id);
                trees.push(fancyTree);
                fancyTree.getRootNode().visit(function (node) {
                    node.setExpanded(true);
                });
            }
        }
    });

});


function expandTreeNode(node) {
    while (node.parent != null) {
        node.setExpanded(true);
        node = node.parent;
    }
}

function createTree($scope, trees, nodes, rootID) {
    var domElement = getScope($scope.$id);
    var container = $(domElement);
    var treeNode = $('<div class="multitreeselector-tree"></div>');
    var idPreFix = null;
    if (rootID != null && rootID != '') {
        idPreFix = rootID + '-';
    }
    container.append(treeNode);
    treeNode.fancytree({
        source: [],
        checkbox: true,
        selectMode: 2,
        select: function (event, data) {
            var values = [];
            for (var i in trees) {
                var itemTree = trees[i];
                var selNodes = itemTree.getSelectedNodes();
                for (var i in selNodes) {
                    var selNode = selNodes[i];
                    values.push(selNode.key);
                }
            }
            $scope.model.value = JSON.stringify(values);
        },
        cookieId: rootID,
        idPrefix: idPreFix
    });
    var fancyTree = treeNode.fancytree("getTree");
    
    var rootNode = fancyTree.getRootNode();
    fillTreeItems(rootNode, nodes, $scope.model.value);
    return fancyTree;
}

function getScope(id) {
    var elem;
    $('.ng-scope').each(function () {
        var s = angular.element(this).scope(),
            sid = s.$id;

        if (sid == id) {
            elem = this;
            return false; // stop looking at the rest
        }
    });
    return elem;
}

function fillTreeItems(treeNode, nodes, selectedValues) {

    for (var i in nodes) {
        var currentNode = nodes[i];
        var subChild = treeNode.addChildren({
            title: currentNode.label,
            key: currentNode.id,
            unselectable: currentNode.children.length > 0,
            hideCheckbox: currentNode.children.length > 0,
            selected: selectedValues != null && selectedValues.indexOf(currentNode.id) > -1
        });
        fillTreeItems(subChild, currentNode.children, selectedValues);

    }

}